import { world, system, ItemStack } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:bronze_statue', {
        onPlayerInteract({ block, player }) {
            const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
            const player_s = block.permutation.withState('v360:shape', 'player')
            const dance = block.permutation.withState('v360:shape', 'dance')
            const scared = block.permutation.withState('v360:shape', 'scared')
            const creeper = block.permutation.withState('v360:shape', 'creeper')
            if (selectedItem?.typeId === 'v360:chisel') {
                if (block.hasTag('v360:bronze_statue_player')) {
                    block.setPermutation(dance)
                }
                else if (block.hasTag('v360:bronze_statue_dance')) {
                    block.setPermutation(scared)
                }
                else if (block.hasTag('v360:bronze_statue_scared')) {
                    block.setPermutation(creeper)
                }
                else if (block.hasTag('v360:bronze_statue_creeper')) {
                    block.setPermutation(player_s)
                }
            }
        }
    })
})